IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CF_CotRemAut_Prod_TX') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION dbo.CF_CotRemAut_Prod_TX
END
GO

CREATE FUNCTION [dbo].[CF_CotRemAut_Prod_TX](@pId_Trans INT, @pItem SMALLINT) 
RETURNS CHAR(131)
AS
BEGIN

/*Variable de Retorno*/
DECLARE @Retorno			CHAR(131) /*124 de caracteres + 7 delimitadores*/
/*FIN Variable de Retorno*/

/*Declaracion de Variables Archivo*/
DECLARE @Delimitador							CHAR(1)
DECLARE @REA_Tipo_Registro						CHAR(2) /*Ini: 001 Fin: 002. Validacion: Al menos 1 registro 03. Comentarios: '03'=Productos*/
DECLARE @REA_Codigo_Unico_Producto				CHAR(6) /*Ini: 003 Fin: 008. Validacion: Alguno de los valores del Nomenclador COT. Comentarios: . Obligatorio: SI*/
DECLARE @REA_Rentas_Codigo_Unidad_Medida		CHAR(1) /*Ini: 009 Fin: 009. Validacion: Valido seg·n tabla de unidad de Medida. Comentarios: AR_ARBA_COT_Tab_UnidMedidaARBA. Obligatorio: SI*/
DECLARE @REA_Cantidad							CHAR(15)/*Ini: 010 Fin: 024. Validacion: > 0. Valores decimales son obligatorios. Comentarios: Ej: si la cantidad es 200, enviar el valor CANTIDAD=20000. Obligatorio: SI*/
DECLARE @REA_Propio_Codigo_Producto				CHAR(25)/*Ini: 025 Fin: 049. Validacion: . Comentarios: . Obligatorio: SI*/
DECLARE @REA_Propio_Descripcion_Producto		CHAR(40)/*Ini: 050 Fin: 089. Validacion: . Comentarios: . Obligatorio: SI*/
DECLARE @REA_Propio_Descripcion_Unidad_Medida	CHAR(20)/*Ini: 090 Fin: 109. Validacion: . Comentarios: . Obligatorio: SI*/
DECLARE @REA_Cantidad_Ajustada					CHAR(15)/*Ini: 110 Fin: 124. Validacion: 13 enteros y 2 decimales. Comentarios: > 0. Valores decimales son obligatorios. Ej: si la cantidad es 200, enviar CANTIDAD=20000. Obligatorio: SI*/
/*FIN Declaracion de Variables Archivo*/



/*Declaracion de Variables Locales*/
DECLARE @Id_AR_ARBA_COT_ProdTipo	VARCHAR(6)
DECLARE @Id_Producto				VARCHAR(14)		
DECLARE @Id_Familia					INT
DECLARE @Id_AR_ARBA_COT_TUMA		SMALLINT
/*FIN Declaracion de Variables Locales*/

SET @Delimitador = '|'

/*Asignacion de Variables Locales*/
SET @Id_AR_ARBA_COT_TUMA		= (SELECT ISNULL(PUM.Id_AR_ARBA_COT_TUMA, 0) FROM Prod_Unid_Medidas PUM, Cbtes_Items CI WHERE PUM.Id_Unidad_Medida = CI.Id_Unidad_Medida AND CI.Id_Trans = @pId_Trans AND CI.Item = @pItem)
SET @Id_Producto				= (SELECT ISNULL(Id_Producto, '') FROM Cbtes_Items WHERE Id_Trans = @pId_Trans AND Item = @pItem)
SET @Id_AR_ARBA_COT_ProdTipo	= (SELECT ISNULL(Id_AR_ARBA_COT_ProdTipo, '') FROM Productos WHERE Id_Producto = @Id_Producto)

IF(@Id_AR_ARBA_COT_ProdTipo = '')
BEGIN
	SET @Id_Familia					= (SELECT ISNULL(Id_Familia, 0) FROM Productos WHERE Id_Producto = @Id_Producto)
	SET @Id_AR_ARBA_COT_ProdTipo	= (SELECT ISNULL(Id_AR_ARBA_COT_ProdTipo, '') FROM Prod_Familias WHERE Id_Familia = @Id_Familia) 
END
/*FIN Asignacion de Variables Locales*/

/*Asignacion de Variables Archivo*/

SET @REA_Tipo_Registro = '03'
SET @REA_Codigo_Unico_Producto = RIGHT('000000' + CAST(@Id_AR_ARBA_COT_ProdTipo AS VARCHAR), 6) /*Solo los de 6 caracteres son seleccionables*/
SET @REA_Rentas_Codigo_Unidad_Medida = (SELECT CONVERT(VARCHAR(1), @Id_AR_ARBA_COT_TUMA))
SET @REA_Cantidad = (SELECT RIGHT('000000000000000' + CAST(CAST((ISNULL(Cantidad,0)) * 100 AS INT) AS VARCHAR), 15) FROM Cbtes_Items WHERE Id_Trans = @pId_Trans AND Item = @pItem)
SET @REA_Propio_Codigo_Producto = @Id_Producto
SET @REA_Propio_Descripcion_Producto = (SELECT SUBSTRING(RTRIM(LTRIM(Descripcion_Resumida)), 0, 40) FROM Productos WHERE Id_Producto = @Id_Producto)
SET @REA_Propio_Descripcion_Unidad_Medida = (SELECT Id_AR_ARBA_COT_TUMA FROM AR_ARBA_COT_Tab_UnidMedidaARBA WHERE Id_AR_ARBA_COT_TUMA = @Id_AR_ARBA_COT_TUMA)
SET @REA_Cantidad_Ajustada = (SELECT RIGHT('000000000000000' + CAST(CAST((ISNULL(Cantidad,0)) * 100 AS INT) AS VARCHAR), 15) FROM Cbtes_Items WHERE Id_Trans = @pId_Trans AND Item = @pItem)
/*FIN Asignacion de Variables Archivo*/

/*Asignacion Variable de Retorno*/
SET @Retorno		=	@REA_Tipo_Registro						+ @Delimitador + @REA_Codigo_Unico_Producto				+ @Delimitador +
						@REA_Rentas_Codigo_Unidad_Medida		+ @Delimitador + @REA_Cantidad							+ @Delimitador +
						@REA_Propio_Codigo_Producto				+ @Delimitador + @REA_Propio_Descripcion_Producto		+ @Delimitador +
						@REA_Propio_Descripcion_Unidad_Medida	+ @Delimitador + @REA_Cantidad_Ajustada
						
RETURN ISNULL(@retorno,'')
END
